"use client";

import { useRouter } from "next/navigation";
import DocTemplateEditor from "@/components/document-template-headers/DocTemplateEditor";

export default function CreateDocTemplatePage() {
  const router = useRouter();

  return (
    <main className="p-4 space-y-4 max-w-4xl mx-auto">
      <div className="flex items-center justify-between">
        <h1 className="text-lg font-semibold">Új dokumentum sablon</h1>
        <button
          onClick={() => router.push("/admin/document-template-headers/list")}
          className="px-3 py-2 text-sm rounded border border-gray-300 hover:bg-gray-50">
          Vissza a listához
        </button>
      </div>

      <DocTemplateEditor
        onSaved={(tpl) => {
          // after first save you could:
          // - go back to list:
          // router.push("/admin/doc-templates");
          // - or navigate to its own edit page:
          router.push(`/admin/document-template-headers/list`);
        }}
      />
    </main>
  );
}
