"use client";

export default function ExportContractsPage() {
  const handleExport = async () => {
    const res = await fetch("/api/export-contracts");

    if (!res.ok) {
      alert("Export failed!");
      return;
    }

    const blob = await res.blob();
    const url = URL.createObjectURL(blob);
    const link = document.createElement("a");
    link.href = url;
    link.download = "contracts.xlsx";
    document.body.appendChild(link);
    link.click();
    link.remove();
  };

  return (
    <div className="p-4">
      <h1 className="text-xl mb-2">Contract Export</h1>
      <button
        onClick={handleExport}
        className="bg-blue-500 text-white px-4 py-2 rounded">
        Export Contracts to Excel
      </button>
    </div>
  );
}
