"use client";
import React, { useState, useEffect, useCallback } from "react";
import ApiCall from "@/api/api-calls";
import toast from "react-hot-toast";
import Loader from "@/components/shared/loader/global-loading";

const CollectionSnapshots = () => {
  const [snapshotList, setSnapshotList] = useState(null);
  const [isLoading, setIsLoading] = useState(null);

  useEffect(() => {
    const fetchSnapshots = async () => {
      const response = await ApiCall.snapshots.getAll();
      if (response.status === 200 && response.data.snapshots) {
        setSnapshotList(response.data.snapshots);
        toast.success("Mentések listája betöltve");
      } else {
        toast.error("Mentések listájának lekérése sikertelen.");
      }
    };
    fetchSnapshots();
  }, []);
  const handleRestore = useCallback((id) => {
    setIsLoading(true);
    const fetchRestore = async () => {
      const restore = await ApiCall.snapshots.postRestore(id);
      if (restore.status === 200 && restore.data.success) {
        toast.success("A mentések visszaállítása sikerült!");
      } else {
        toast.error("A mentések visszaállítása sikertelen volt!");
      }
      setIsLoading(false);
    };
    fetchRestore();
  }, []);
  console.log("snapshotList", snapshotList);
  if (isLoading) return <Loader />;

  return (
    <>
      {snapshotList && (
        <table className="w-full table-auto border-collapse border border-gray-300">
          <thead className="bg-gray-100">
            <tr>
              <th className="text-left p-2 border border-gray-300">
                Azonosító
              </th>
              <th className="text-left p-2 border border-gray-300">Verzió</th>
              <th className="text-left p-2 border border-gray-300">
                Készítés ideje
              </th>
              <th className="text-left p-2 border border-gray-300">Művelet</th>
            </tr>
          </thead>
          <tbody>
            {snapshotList.map((snapshot, index) => (
              <tr key={index} className="hover:bg-gray-50">
                <td className="p-2 border border-gray-300">{snapshot.id}</td>
                <td className="p-2 border border-gray-300">
                  {snapshot.version}
                </td>
                <td className="p-2 border border-gray-300">
                  {new Date(snapshot.versionedAt).toLocaleString()}
                </td>
                <td className="p-2 border border-gray-300">
                  <button
                    className="text-blue-600 hover:underline"
                    onClick={() => handleRestore(snapshot.id)}>
                    Visszaállítás
                  </button>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      )}
    </>
  );
};

export default CollectionSnapshots;
