"use client";
import React, { useEffect, useState } from "react";
import Button from "@/components/shared/button/Button";
import { reorder } from "@/utils/reorder";
import { DragAndDrop, Drag, Drop } from "@/components/shared/DragDrop";
import ApiCall from "@/api/api-calls";
import toast from "react-hot-toast";
import { useAdminMenu } from "@/hooks/useAdminMenu";

const AdminMenuCategoryReorder = () => {
  const [categories, setCategories] = useState(null);
  const { refreshMenu } = useAdminMenu();

  useEffect(() => {
    const fetchData = async () => {
      const response = await ApiCall.adminMenuCategory.getReorder();
      if (response.status === 200) {
        setCategories(response?.data?.body?.ret);
      }
    };
    fetchData();
  }, []);

  const handleDragEnd = (result) => {
    const { type, source, destination } = result;
    if (!destination) return;

    const sourceCategoryId = source.droppableId;
    const destinationCategoryId = destination.droppableId;

    if (type === "droppable-item") {
      if (sourceCategoryId === destinationCategoryId) {
        // same category reorder
        const updated = categories.map((cat) =>
          cat.id !== sourceCategoryId
            ? cat
            : {
                ...cat,
                items: reorder(cat.items, source.index, destination.index),
              }
        );
        setCategories(updated);
        return;
      }

      // move between categories (JS-safe, no non-null assertions)
      const updated = categories.map((c) => ({
        ...c,
        items: [...(c.items || [])],
      }));
      const srcIdx = updated.findIndex((c) => c.id === sourceCategoryId);
      const dstIdx = updated.findIndex((c) => c.id === destinationCategoryId);
      if (srcIdx === -1 || dstIdx === -1) return;

      const [moved] = updated[srcIdx].items.splice(source.index, 1);
      updated[dstIdx].items.splice(destination.index, 0, moved);

      // optional: keep indices tidy
      updated[srcIdx].items = updated[srcIdx].items.map((it, i) => ({
        ...it,
        index: i,
      }));
      updated[dstIdx].items = updated[dstIdx].items.map((it, i) => ({
        ...it,
        index: i,
      }));

      setCategories(updated);
      return;
    }

    if (type === "droppable-category") {
      setCategories(reorder(categories, source.index, destination.index));
    }
  };

  // const handleDragEnd = (result) => {
  //   const { type, source, destination } = result;
  //   if (!destination) return;

  //   const sourceCategoryId = source.droppableId;
  //   const destinationCategoryId = destination.droppableId;

  //   // Reordering items
  //   // if (type === "droppable-item") {
  //   //   // If drag and dropping within the same category
  //   //   if (sourceCategoryId === destinationCategoryId) {
  //   //     const updatedOrder = reorder(
  //   //       categories.find((category) => category.id === sourceCategoryId).items,
  //   //       source.index,
  //   //       destination.index
  //   //     );
  //   //     const updatedCategories = categories.map((category) =>
  //   //       category.id !== sourceCategoryId
  //   //         ? category
  //   //         : { ...category, items: updatedOrder }
  //   //     );

  //   //     setCategories(updatedCategories);
  //   //   } else {
  //   //     const sourceOrder = categories.find(
  //   //       (category) => category.id === sourceCategoryId
  //   //     ).items;
  //   //     const destinationOrder = categories.find(
  //   //       (category) => category.id === destinationCategoryId
  //   //     ).items;

  //   //     const [removed] = sourceOrder.splice(source.index, 1);
  //   //     destinationOrder.splice(destination.index, 0, removed);

  //   //     destinationOrder[removed] = sourceOrder[removed];
  //   //     delete sourceOrder[removed];

  //   //     const updatedCategories = categories.map((category) =>
  //   //       category.id === sourceCategoryId
  //   //         ? { ...category, items: sourceOrder }
  //   //         : category.id === destinationCategoryId
  //   //         ? { ...category, items: destinationOrder }
  //   //         : category
  //   //     );

  //   //     setCategories(updatedCategories);
  //   //   }
  //   // }

  //   if (type === "droppable-item") {
  //     if (sourceCategoryId === destinationCategoryId) {
  //       // same category
  //       const updated = categories.map((cat) =>
  //         cat.id !== sourceCategoryId
  //           ? cat
  //           : {
  //               ...cat,
  //               items: reorder(cat.items, source.index, destination.index),
  //             }
  //       );
  //       setCategories(updated);
  //     } else {
  //       // cross-category move (JS-safe)
  //       const updated = categories.map((c) => ({
  //         ...c,
  //         items: [...(c.items || [])],
  //       }));

  //       const srcIdx = updated.findIndex((c) => c.id === sourceCategoryId);
  //       const dstIdx = updated.findIndex((c) => c.id === destinationCategoryId);
  //       if (srcIdx === -1 || dstIdx === -1) return; // nothing to do if not found

  //       const [moved] = updated[srcIdx].items.splice(source.index, 1);
  //       updated[dstIdx].items.splice(destination.index, 0, moved);

  //       // (optional) reindex for UI/debug consistency
  //       updated[srcIdx].items = updated[srcIdx].items.map((it, i) => ({
  //         ...it,
  //         index: i,
  //       }));
  //       updated[dstIdx].items = updated[dstIdx].items.map((it, i) => ({
  //         ...it,
  //         index: i,
  //       }));

  //       setCategories(updated);
  //     }
  //   }

  //   // Reordering categories
  //   if (type === "droppable-category") {
  //     const updatedCategories = reorder(
  //       categories,
  //       source.index,
  //       destination.index
  //     );

  //     setCategories(updatedCategories);
  //   }
  // };
  const handleSubmit = () => {
    // const ret = [];

    // categories?.map((c, i) => {
    //   const obj = {};
    //   obj._id = c._id;
    //   obj.name = c.name;
    //   obj.index = i;
    //   const childList = [];
    //   c?.items?.map((item, idx) => {
    //     const child = {};
    //     child._id = item._id;
    //     child.name = item.name;
    //     child.index = idx;
    //     childList.push(child);
    //   });
    //   obj.items = childList;
    //   ret.push(obj);
    // });
    const ret = categories.map((c, i) => ({
      _id: c._id,
      name: c.name,
      index: i,
      items: (c.items || []).map((item, idx) => ({
        _id: item._id,
        name: item.name,
        index: idx,
        type: item.type ?? "menu", // keep original; default to 'menu' if missing
      })),
    }));

    const fetchData = async () => {
      const response = await ApiCall.adminMenuCategory.postReorder(ret);
      if (response.status === 200) {
        toast.success(response?.data?.message);
        await refreshMenu();
      } else {
        toast.error(response?.data?.error);
      }
    };

    fetchData();
  };
  return (
    <>
      {categories && (
        <>
          <DragAndDrop onDragEnd={handleDragEnd}>
            <Drop id="droppable" type="droppable-category">
              {categories?.map((category, categoryIndex) => {
                return (
                  <Drag
                    className="draggable-category w-1/2"
                    key={category.id}
                    id={category._id}
                    index={categoryIndex}>
                    <div
                      className="category-container"
                      data-index={categoryIndex}
                      data-id={category._id}>
                      <h2 className="item">{category.name}</h2>
                      <Drop
                        key={category.id}
                        id={category.id}
                        type="droppable-item">
                        {category.items.map((item, index) => {
                          return category.items.length > 1 ? (
                            <Drag
                              className={`${"draggable w-1/2"} `}
                              key={item.id}
                              id={item.id}
                              index={index}>
                              <div
                                className="item"
                                data-inner-index={index}
                                data-id={item._id}>
                                {item.name}
                              </div>
                            </Drag>
                          ) : (
                            <div
                              key={item.id}
                              id={item.id}
                              index={index}
                              className="w-1/2">
                              <div
                                className="item"
                                data-inner-index={index}
                                data-id={item._id}>
                                {item.name}
                              </div>
                            </div>
                          );
                        })}
                      </Drop>
                    </div>
                  </Drag>
                );
              })}
            </Drop>
          </DragAndDrop>
          <div className="w-full fixed bottom-0 overflow-x-hidden bg-white flex flex-row justify-start items-center py-4 border-t border-t-gray-300">
            <Button
              btntext="Mentés"
              onClick={handleSubmit}
              className="bg-blue-600/75 rounded disabled:bg-gray-300 enabled:hover:bg-blue-600 px-4 py-2 text-white"></Button>
          </div>
        </>
      )}
    </>
  );
};

export default AdminMenuCategoryReorder;
