"use client";
import { useEffect, useState } from "react";
import aclApi from "@/api/routes/acl";

type Resource = {
  id: string;
  key: string;
  pattern: string;
  description?: string | null;
};

export default function ResourcesPage() {
  const [resources, setResources] = useState<Resource[]>([]);
  useEffect(() => {
    (async () => {
      const res = await aclApi.listResources();
      setResources(res.data.resources ?? []);
    })();
  }, []);
  return (
    <div className="p-6 space-y-4">
      <h1 className="text-2xl font-semibold">Resources</h1>
      <div className="border rounded">
        <table className="w-full text-sm">
          <thead>
            <tr className="bg-gray-50 text-left">
              <th className="p-2">Key</th>
              <th className="p-2">Pattern</th>
              <th className="p-2">Description</th>
            </tr>
          </thead>
          <tbody>
            {resources.map((r) => (
              <tr key={r.id} className="border-t">
                <td className="p-2 font-mono">{r.key}</td>
                <td className="p-2">{r.pattern}</td>
                <td className="p-2">{r.description || "-"}</td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
      <p className="text-xs text-gray-500">
        These are synced from your Express router tree on server start.
      </p>
    </div>
  );
}
