// src/lib/api/routes/faqs.ts
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseTemplateDocumentsApi = {
  // query should include ? if needed, e.g. "?search=..."
  getList: (params?: { kind_code?: string; template_type_id?: string }) =>
    apiClient.get(`/api/admin/template-documents/list`, { params }),

  // view-only (public-ish) version
  getView: (id: string) =>
    apiClient.get(`/api/admin/template-documents/${id}/view`),

  // full admin version (for editing)
  getItem: (id: string) => apiClient.get(`/api/admin/template-documents/${id}`),

  // create or update
  upsertItem: (payload: object) =>
    apiClient.post(`/api/admin/template-documents`, payload),

  // download DOCX
  exportDocx: (id: string) =>
    apiClient.get(`/api/admin/template-documents/${id}/export-docx`, {
      // depends on your apiClient impl, but usually:
      responseType: "blob",
    }),
  printDocx: (id: string) =>
    apiClient.get(`/api/admin/template-documents/${id}/print`),
  removeMany(ids: string[]) {
    return apiClient.post("/api/admin/template-documents/bulk-delete", { ids });
  },

  removeOne(id: string) {
    return apiClient.delete(`/api/admin/template-documents/${id}/delete`);
  },
  fillAndSend: (id: string, payload: any) =>
    apiClient.post(
      `/api/admin/template-documents/${id}/fill-and-send`,
      payload
    ),
  getFormEditorList: (params?: any) =>
    apiClient.get("/api/admin/template-documents/doc-forms", { params }),
  getFormEditorItem: (id: string) =>
    apiClient.get(`/api/admin/template-documents/doc-forms/${id}`),
  upsertFormEditorItem: (payload: any) =>
    apiClient.post("/api/admin/template-documents/doc-forms", payload),
  removeFormEditor: (id: string) =>
    apiClient.delete(`/api/admin/template-documents/doc-forms/${id}`),
};

const templateDocumentsApi = wrapApiWithTokenRefresh(
  baseTemplateDocumentsApi,
  []
);

export default templateDocumentsApi;
