import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseStagingApi = {
  getProductGroupStaging: (params) =>
    apiClient.get(`/api/admin/staging/product-groups`, { params }),
  approveProductGroup: (id) =>
    apiClient.post(`/api/admin/staging/product-groups/${id}/approve`),
  discardProductGroup: (id) =>
    apiClient.delete(`/api/admin/staging/product-groups/${id}`),
  getProductStaging: (params) =>
    apiClient.get(`/api/admin/staging/products`, { params }),
  approveProduct: (id) =>
    apiClient.post(`/api/admin/staging/products/${id}/approve`),
  approveAllProducts: (params) =>
    apiClient.post(`/api/admin/staging/products/approve-all`, null, { params }),
  discardAllProducts: (params) =>
    apiClient.delete(`/api/admin/staging/products/discard-all`, { params }),
  discardProduct: (id) => apiClient.delete(`/api/admin/staging/products/${id}`),
  getCategoryStaging: (params) =>
    apiClient.get(`/api/admin/staging/product-categories`, { params }),
  approveCategory: (id) =>
    apiClient.post(`/api/admin/staging/product-categories/${id}/approve`),
  discardCategory: (id) =>
    apiClient.delete(`/api/admin/staging/product-categories/${id}`),
  uploadStagingProducts: (data) =>
    apiClient.post(`/api/admin/staging/product-groups/upload`, data),
};
const stagingApi = wrapApiWithTokenRefresh(baseStagingApi, ["getAll"]);

export default stagingApi;
