// src/api/routes/seller-types.js
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseSellerTypesApi = {
  getList: (query) => apiClient.get(`/api/admin/seller-types/list${query}`),
  postCreate: (data) => apiClient.post("/api/admin/seller-types/save", data),
  getEdit: (id) => apiClient.get(`/api/admin/seller-types/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/seller-types/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/seller-types/delete", { ids }),
};

const sellerTypesApi = wrapApiWithTokenRefresh(baseSellerTypesApi, ["getList"]);
export default sellerTypesApi;
