import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseProductPropertiesApi = {
  getColorList: (query) =>
    apiClient.get(`/api/admin/product-color/list/${query}`),
  getCreateColor: () => apiClient.get(`/api/admin/product-color/create`),
  putCreateColor: (data) =>
    apiClient.put(`/api/admin/product-color/create`, data),
  getEditColor: (id) => apiClient.get(`/api/admin/product-color/edit/${id}`),
  postEditColor: (id, data) =>
    apiClient.post(`/api/admin/product-color/edit/${id}`, data),
  deletColors: (ids) =>
    apiClient.post(`/api/admin/product-color/delete-color`, ids),

  getSizeList: (query) =>
    apiClient.get(`/api/admin/product-size/list/${query}`),
  getCreateSize: () => apiClient.get(`/api/admin/product-size/create`),
  putCreate: (data) => apiClient.put(`/api/admin/product-size/create`, data),
  getEditSize: (id) => apiClient.get(`/api/admin/product-size/edit/${id}`),
  postEditSize: (id, data) =>
    apiClient.post(`/api/admin/product-size/edit/${id}`, data),
  getSizeReorder: () => apiClient.get(`/api/admin/product-size/reorder`),
  postSizeReorder: (data) =>
    apiClient.post(`/api/admin/product-size/reorder`, data),
  deletSizes: (ids) =>
    apiClient.post(`/api/admin/product-size/delete-size`, ids),

  //   getBrandsList: (query) =>
  //     apiClient.post(`/api/admin/product-size/list/${query}`),
  //   getBrandsColor: () => apiClient.get(`/api/admin/product-size/create`),
  //   putBrandsColor: () => apiClient.get(`/api/admin/product-size/create`),
  //   getEditBrands: (id) => apiClient.get(`/api/admin/product-size/edit/${id}`),
  //   postEditBrands: (id, data) =>
  //     apiClient.get(`/api/admin/product-size/edit/${id}`, data),
  //   deletBrands: (ids) =>
  //     apiClient.post(`/api/admin/product-size/delete-size`, ids),

  getTagsList: (query) =>
    apiClient.post(`/api/admin/product-tags/list/${query}`),
  geTagsColor: () => apiClient.get(`/api/admin/product-tags/create`),
  putTagsColor: () => apiClient.put(`/api/admin/product-tags/create`),
  getEditTags: (id) => apiClient.get(`/api/admin/product-tags/edit/${id}`),
  postEditTags: (id, data) =>
    apiClient.post(`/api/admin/product-tags/edit/${id}`, data),
  deletTags: (ids) =>
    apiClient.post(`/api/admin/product-tags/delete-tags`, ids),
};
const productPropertiesApi = wrapApiWithTokenRefresh(baseProductPropertiesApi, [
  "",
]);

export default productPropertiesApi;
