import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseProductGroupsApi = {
  getAll: (query) => apiClient.get(`/api/admin/product-groups/list${query}`),
  getEdit: (id) => apiClient.get(`/api/admin/product-groups/edit/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/product-groups/edit/${id}`, data),
  getProductList: (data) =>
    apiClient.post(`/api/admin/product-groups/productlist/`, data),
  upload: (formData) =>
    apiClient.post(`/api/admin/product-groups/upload-xlsx-products`, formData),
  exportEmptyList: async () => {
    try {
      const response = await apiClient.get(
        `/api/admin/product-groups/export-empty-xls`,
        {
          responseType: "blob",
        }
      );

      if (response.status !== 200) {
        console.error("Download failed, status:", response.status);
        return;
      }

      // 🚨 This is the crucial part
      const contentDisposition =
        response.headers.get?.("content-disposition") ||
        response.headers["content-disposition"] ||
        response.headers["Content-Disposition"];

      let filename = "termekcsoportok.xlsx";

      if (contentDisposition) {
        const match = contentDisposition.match(
          /filename\*?=(?:UTF-8''|")?([^;"]+)/
        );
        if (match && match[1]) {
          filename = decodeURIComponent(match[1].replace(/["']/g, ""));
        }
      }

      const blob = response.data;
      const url = window.URL.createObjectURL(blob);
      const a = document.createElement("a");
      a.href = url;
      a.download = filename;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      window.URL.revokeObjectURL(url);
    } catch (error) {
      console.error("Download error:", error);
    }
  },
  exportList: async () => {
    try {
      const response = await apiClient.get(
        `/api/admin/product-groups/export-to-xls`,
        {
          responseType: "blob",
        }
      );

      if (response.status !== 200) {
        console.error("Download failed, status:", response.status);
        return;
      }

      // 🚨 This is the crucial part
      const contentDisposition =
        response.headers.get?.("content-disposition") ||
        response.headers["content-disposition"] ||
        response.headers["Content-Disposition"];

      let filename = "termekcsoportok.xlsx";

      if (contentDisposition) {
        const match = contentDisposition.match(
          /filename\*?=(?:UTF-8''|")?([^;"]+)/
        );
        if (match && match[1]) {
          filename = decodeURIComponent(match[1].replace(/["']/g, ""));
        }
      }

      const blob = response.data;
      const url = window.URL.createObjectURL(blob);
      const a = document.createElement("a");
      a.href = url;
      a.download = filename;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      window.URL.revokeObjectURL(url);
    } catch (error) {
      console.error("Download error:", error);
    }
  },

  // exportList: async () => {
  //   try {
  //     const response = await apiClient.get(
  //       `/api/admin/product-groups/export-to-xls`,
  //       {
  //         responseType: "blob", // 👈 necessary for downloading binary files
  //       }
  //     );

  //     const blob = response.data;

  //     const url = window.URL.createObjectURL(blob);
  //     const a = document.createElement("a");
  //     a.href = url;
  //     a.download = "termekcsoportok.xlsx";
  //     document.body.appendChild(a);
  //     a.click();
  //     document.body.removeChild(a);
  //     window.URL.revokeObjectURL(url);
  //   } catch (error) {
  //     console.error("Download error:", error);
  //   }
  // },
  getVersions: async (id) =>
    apiClient.get(`/api/admin/product-groups/${id}/versions`),
  restoreVersion: async (id, version) =>
    apiClient.post(`/api/admin/product-groups/${id}/restore/${version}`),
};
const productGroupsApi = wrapApiWithTokenRefresh(baseProductGroupsApi, [
  "getAll",
]);

export default productGroupsApi;
