import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseProductCategoriesApi = {
  getAll: () => apiClient.get(`/api/admin/product-categories/select`),
  getList: (query) =>
    apiClient.get(`/api/admin/product-categories/list${query}`),
  getCreate: () => apiClient.get("/api/admin/product-categories/create"),
  putCreate: (data) =>
    apiClient.put("/api/admin/product-categories/create", data),
  getEdit: (id) => apiClient.get(`/api/admin/product-categories/edit/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/product-categories/edit/${id}`, data),
  getReorder: () => apiClient.get("/api/admin/product-categories/reorder"),
  postReorder: (data) =>
    apiClient.post("/api/admin/product-categories/reorder", data),
  deleteCategory: (ids) =>
    apiClient.post("/api/admin/product-categories/delete-category/", ids),
  exportList: async () => {
    try {
      const response = await apiClient.get(
        `/api/admin/product-categories/export-categories`,
        {
          responseType: "blob", // 👈 necessary for downloading binary files
        }
      );

      const blob = response.data;

      const url = window.URL.createObjectURL(blob);
      const a = document.createElement("a");
      a.href = url;
      a.download = "termekkategoriak.xlsx";
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      window.URL.revokeObjectURL(url);
    } catch (error) {
      console.error("Download error:", error);
    }
  },
  getMainCategories: () => apiClient.get(`/api/admin/product-categories/main`),
  checkCategorySlug: (slug) =>
    apiClient.get(`/api/admin/product-categories/slug/${slug}`),
  getAllCategories: async () =>
    apiClient.get("/api/admin/product-categories/categories-list"),
  upload: (formData) =>
    apiClient.post(
      `/api/admin/product-categories/upload-xlsx-categories`,
      formData
    ),
  getCategoriesSelect: () =>
    apiClient.get(`/api/admin/product-categories/get-categories-select`),
};

const productCategoriesApi = wrapApiWithTokenRefresh(baseProductCategoriesApi, [
  "getAll",
  "getMainCategories",
]);

export default productCategoriesApi;
