// src/api/routes/playbooks.ts
import apiClient from "@/lib/apiClient";

export type Playbook = {
  id: string;
  key: string;
  name: string;
  description?: string | null;
  default_case_type?: string | null;
  default_flow_type?: string | null;
  is_active: boolean;
  created_at?: string;
  updated_at?: string;
};

export type PlaybookStep = {
  id: string;
  playbook_id: string;
  sort_order: number;
  title: string;
  description?: string | null;
};

export const playbooksApi = {
  list: (params?: { includeInactive?: 0 | 1 }) =>
    apiClient.get<{ playbooks: Playbook[] }>(`/api/admin/playbooks`, {
      params,
    }),

  detail: (playbookRef: string) =>
    apiClient.get<{ playbook: Playbook; steps: PlaybookStep[] }>(
      `/api/admin/playbooks/${playbookRef}`
    ),

  create: (payload: {
    key: string;
    name: string;
    description?: string;
    defaultCaseType?: string | null;
    defaultFlowType?: "projekt" | "folyamatos" | null;
    isActive?: boolean;
  }) => apiClient.post<{ playbook: Playbook }>(`/api/admin/playbooks`, payload),

  update: (
    playbookRef: string,
    payload: {
      name?: string;
      description?: string | null;
      defaultCaseType?: string | null;
      defaultFlowType?: "projekt" | "folyamatos" | null;
      isActive?: boolean;
    }
  ) => apiClient.patch(`/api/admin/playbooks/${playbookRef}`, payload),

  createStep: (
    playbookRef: string,
    payload: { sortOrder?: number; title: string; description?: string | null }
  ) =>
    apiClient.post<{ step: PlaybookStep }>(
      `/api/admin/playbooks/${playbookRef}/steps`,
      payload
    ),

  updateStep: (
    playbookRef: string,
    stepId: string,
    payload: { sortOrder?: number; title?: string; description?: string | null }
  ) =>
    apiClient.patch(
      `/api/admin/playbooks/${playbookRef}/steps/${stepId}`,
      payload
    ),

  deleteStep: (playbookRef: string, stepId: string) =>
    apiClient.delete(`/api/admin/playbooks/${playbookRef}/steps/${stepId}`),
};

export default playbooksApi;
