import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";
const base = "/api/admin/phone-registry";
const basePhoneRegistryApi = {
  getList: (qs = "") => apiClient.get(`${base}${qs}`), // currently your BE returns all; qs reserved for future filters
  getOne: (id: string) => apiClient.get(`${base}?id=${id}`), // optional (see note in Expanded)
  upsert: (payload: any) => apiClient.post(base, payload),
  update: (id: string, payload: any) =>
    apiClient.post(base, { id, ...payload }), // reuse upsert
  remove: (id: string) => apiClient.delete(`${base}/${id}`),

  // import
  uploadXlsx: (file: File) => {
    const fd = new FormData();
    fd.append("file", file);
    return apiClient.post(`${base}/import`, fd, {
      headers: { "Content-Type": "multipart/form-data" },
    });
  },
  exportXlsx: (query: string) =>
    apiClient.get(
      `/api/admin/phone-registry/export${query}${query ? "&" : "?"}format=xlsx`,
      { responseType: "blob" }
    ),
  shortCodeOptions: (q = "", limit = 50) =>
    apiClient.get(`${base}/options/short-codes`, { params: { q, limit } }),
  departmentOptions: (q = "", limit = 50) =>
    apiClient.get(`${base}/options/departments`, { params: { q, limit } }),
  internetPackageOptions: (q = "", limit = 50) =>
    apiClient.get(`${base}/options/internet-packages`, {
      params: { q, limit },
    }),
  peopleOptions: (q = "", limit = 50) =>
    apiClient.get(`${base}/options/people`, { params: { q, limit } }),
  companySegmentOptions: (q = "", limit = 50) =>
    apiClient.get(`${base}/options/company-segments`, { params: { q, limit } }),
  statusOptions: (q = "", limit = 50) =>
    apiClient.get(`${base}/options/statuses`, { params: { q, limit } }),
};

const phoneRegistryApi = wrapApiWithTokenRefresh(basePhoneRegistryApi, []);
export default phoneRegistryApi;
