// src/api/api-calls/peoples.ts (or wherever this lives)
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const basePeoplesApi = {
  getLocations: () => apiClient.get(`/api/admin/location/select`),

  // LIST
  getList: (query: string) => apiClient.get(`/api/admin/people${query}`),

  // DETAIL
  getOne: (id: string) => apiClient.get(`/api/admin/people/${id}`),

  // UPSERT HR data
  upsert: (payload: any) => apiClient.post(`/api/admin/people`, payload),

  // DEACTIVATE
  deactivate: (id: string) => apiClient.delete(`/api/admin/people/${id}`),

  // HR picklists
  getStatuses: () => apiClient.get(`/api/admin/people/person-statuses`),
  getDepartments: () => apiClient.get(`/api/admin/people/company-departments`),

  // People search (for manager select)
  searchPeopleOptions: (search: string) =>
    apiClient.get(
      `/api/admin/people/options?search=${encodeURIComponent(search)}`
    ),

  // 🔹 HR timeline (people router)
  getTimeline: (id: string) =>
    apiClient.get(`/api/admin/people/${id}/timeline`),

  // 🔹 HR tasks (hr router)
  getTasks(personId: string, params?: { companyId?: string }) {
    const qs = params?.companyId
      ? `?companyId=${encodeURIComponent(params.companyId)}`
      : "";
    return apiClient.get(`/api/admin/people/${personId}/tasks${qs}`);
  },
  getOwnCompanies() {
    return apiClient.get("/api/admin/people/own-companies");
  },
  // create / update one HR task
  createOrUpdateTask: (personId: string, payload: any) =>
    apiClient.post(`/api/admin/people/${personId}/tasks`, {
      ...payload,
      person_id: personId, // BE zod expects this 👈
    }),
  // mark task done
  completeTask: (taskId: string) =>
    apiClient.post(`/api/admin/hr-tasks/${taskId}/complete`, {}),
  deleteTask: (taskId: string) =>
    apiClient.delete(`/api/admin/hr-tasks/${taskId}/delete`, {}),
  // start offboarding (creates tasks + marks exited)
  startOnboarding(personId: string, companyId: string) {
    return apiClient.post(
      `/api/admin/people/${personId}/companies/${companyId}/onboarding/start`
    );
  },
  startOffboarding(personId: string, companyId: string) {
    return apiClient.post(
      `/api/admin/people/${personId}/companies/${companyId}/offboarding/start`
    );
  },

  getEmployments(personId: string) {
    return apiClient.get(`/api/admin/people/${personId}/employments`);
  },
  upsertEmployment(
    personId: string,
    payload: {
      id?: string;
      company_id: string;
      hired_at?: string | null;
      exited_at?: string | null;
      employment_type?: string | null;
      contract_number?: string | null;
      is_primary?: boolean;
    }
  ) {
    return apiClient.post(`/api/admin/people/${personId}/employments`, payload);
  },

  deleteEmployment(id: string) {
    return apiClient.delete(`/api/admin/people/employments/${id}`);
  },

  getCompanyOptions() {
    return apiClient.get(`/api/admin/hr/own-companies/options`);
  },
};

const peoplesApi = wrapApiWithTokenRefresh(basePeoplesApi, ["getLocations"]);
export default peoplesApi;
