import Cookies from "js-cookie";
import apiClient, { setServerToken } from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const token = Cookies.get("edSId");

setServerToken(token);

const basePageEditorApi = {
  getAll: (query) => apiClient.get(`/api/admin/page-editor/list${query}`),
  getCreatePageEditor: () => apiClient.get(`/api/admin/page-editor/create`),
  putCreatePageEditor: (data) =>
    apiClient.put(`/api/admin/page-editor/create`, data),
  getUpdatePageEditor: (id) =>
    apiClient.get(`/api/admin/page-editor/edit/${id}`),
  postUpdatePageEditor: (id, data) =>
    apiClient.post(`/api/admin/page-editor/edit/${id}`, data),
  deletePageEditor: (ids) =>
    apiClient.post(`/api/admin/page-editor/delete-editor`, ids),
};
const pageEditorApi = wrapApiWithTokenRefresh(basePageEditorApi, ["create"]);
export default pageEditorApi;
