import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseOwnCompanyGroupsApi = {
  getList: (query) => apiClient.get(`/api/admin/company-group/list${query}`),
  getEdit: (id) => apiClient.get(`/api/admin/company-group/${id}`),
  postSave: (data) => apiClient.post("/api/admin/company-group/save", data),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/company-group/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/company-group/delete", { ids }),
};
const ownCompanyGroupsApi = wrapApiWithTokenRefresh(baseOwnCompanyGroupsApi, [
  "",
]);
export default ownCompanyGroupsApi;
