import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseOwnCompanyApi = {
  getList: (query) => apiClient.get(`/api/admin/own-company/list${query}`),
  getAllNames: () => apiClient.get("/api/admin/own-company/all-names"),
  getAllGroupNames: () =>
    apiClient.get("/api/admin/own-company/all-group-names"),
  getAllShortNames: () =>
    apiClient.get("/api/admin/own-company/all-short-codes"),
  postCreate: (data) => apiClient.post("/api/admin/own-company/create", data),
  getEdit: (id) => apiClient.get(`/api/admin/own-company/edit/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/own-company/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/own-company/delete", { ids }),
};
const ownCompanyApi = wrapApiWithTokenRefresh(baseOwnCompanyApi, [
  "getCompanyList",
]);
export default ownCompanyApi;
