import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseMessagesApi = {
  getFrontendMessagesList: (query) =>
    apiClient.get(`/api/admin/frontend-messages/list${query}`),
  getFrontendMessages: () =>
    apiClient.get("/api/admin/frontend-messages/frontend"),
  getCreateFrontendMessage: () =>
    apiClient.get("/api/admin/frontend-messages/create"),
  putCreateFrontendMessage: (data) =>
    apiClient.put("/api/admin/frontend-messages/create", data),
  getEditFrontentMessage: (id) =>
    apiClient.get(`/api/admin/frontend-messages/edit/${id}`),
  postEditFrontendMessage: (id, data) =>
    apiClient.post(`/api/admin/frontend-messages/edit/${id}`, data),
  deleteFrontendMessages: (ids) =>
    apiClient.post(`/api/admin/frontend-messages/delete/`, ids),
};
const messagesApi = wrapApiWithTokenRefresh(baseMessagesApi, []);

export default messagesApi;
