// src/api/routes/location-types.js
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseLocationTypesApi = {
  getList: (query) => apiClient.get(`/api/admin/location-types/list${query}`),
  postCreate: (data) => apiClient.post("/api/admin/location-types/save", data),
  getEdit: (id) => apiClient.get(`/api/admin/location-types/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/location-types/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/location-types/delete", { ids }),
};

const locationTypesApi = wrapApiWithTokenRefresh(baseLocationTypesApi, [
  "getList",
]);
export default locationTypesApi;
