import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseLayoutSettingsApi = {
  getLayoutSettings: () => apiClient.get("/api/admin/layout-settings/layout"),
  postLayoutSettings: (data) =>
    apiClient.post(`/api/admin/layout-settings/layout`, data),
  getMaintenanceStatus: () =>
    apiClient.get(`/api/admin/maintenance-mode/status`),
  setMaintenanceStatus: (value) =>
    apiClient.post(`/api/admin/maintenance-mode/status`, value),
};
const layoutSettingsApi = wrapApiWithTokenRefresh(baseLayoutSettingsApi, []);

export default layoutSettingsApi;
