import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseGlobalsApi = {
  getCurrentExchangeRate: () =>
    apiClient.get("/api/admin/exchange-rate/current"),
  getExchangeRateEdit: () => apiClient.get(`/api/admin/exchange-rate/update`),
  postExchangeRateEdit: (data) =>
    apiClient.post(`/api/admin/exchange-rate/update`, data),
  getGlobalProductDiscountEdit: () =>
    apiClient.get(`/api/admin/global-discount/update`),
  postGlobalProductDiscountEdit: (data) =>
    apiClient.post(`/api/admin/global-discount/update`, data),
  getCategoryDiscountEdit: () =>
    apiClient.get(`/api/admin/global-discount/category-discount/update`),
  postCategoryDiscountEdit: (data) =>
    apiClient.post(`/api/admin/global-discount/category-discount/update`, data),
};
const globalsApi = wrapApiWithTokenRefresh(baseGlobalsApi, []);

export default globalsApi;
