import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseFilingApi = {
  getList: (query) => apiClient.get(`/api/admin/filing/list${query}`),
  getCreate: () => apiClient.get(`/api/admin/filing/create`),
  postCreate: (data) => apiClient.post(`/api/admin/filing/create`, data),
  getOne: (id) => apiClient.get(`/api/admin/filing/edit/${id}`),
  postUpsert: (id, data) =>
    apiClient.post(`/api/admin/filing/edit/${id}`, data),
  delete: (ids) => apiClient.post(`/api/admin/filing/delete`, ids),
  getAllSelectOptions: () => apiClient.get("/api/admin/filing/select-options"),
  getNextRegNumber: (params) =>
    apiClient.get("/api/admin/filing/reg-number", { params }),
  upload: (data) => apiClient.post("/api/admin/filing/upload", data),
  attachDocumentToAsset: (id, data) =>
    apiClient.post(`/api/admin/filing/${id}/documents`, data),
  uploadDocument: (filingId, data) =>
    apiClient.post(`/api/admin/filing/${filingId}/documents`, data),
  listDocuments: (filingId) =>
    apiClient.get(`/api/admin/filing/${filingId}/documents`),
  download: (query) =>
    apiClient.get(`/api/admin/filing/export-to-xls${query}`, {
      responseType: "blob",
    }),
};

const filingApi = wrapApiWithTokenRefresh(baseFilingApi, []);

export default filingApi;
