// app/api/routes/email-signature.ts
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

export type MedicalCenterOption = {
  id: string;
  name: string;
};

export type CompanyAddressOption = {
  id: string;
  label: string;
};

export type PhoneLineOption = {
  id: string;
  phone_number: string;
};

export type EmailSignatureOptionsResponse = {
  centers: MedicalCenterOption[];
  addresses: CompanyAddressOption[];
  phoneLines: PhoneLineOption[];
};

// ✅ Preset types
export type EmailSignatureTemplateId = "classic" | "compact" | "logoTop";
export type EmailSignatureIconPackId = "flatBlue" | "monoDark";
export type EmailSignatureSocialType =
  | "linkedin"
  | "facebook"
  | "instagram"
  | "youtube"
  | "x";

export type EmailSignatureSocialLink = {
  id: string;
  type: EmailSignatureSocialType;
  url: string;
};

export type EmailSignaturePresetConfig = {
  templateId: EmailSignatureTemplateId;
  iconPackId: EmailSignatureIconPackId;

  name: string;
  position: string;
  companyId: string;
  addressId: string;
  phoneId: string;
  website: string;
  email: string;
  quote: string;

  socialEnabled: boolean;
  socialLinks: EmailSignatureSocialLink[];
};

export type GetEmailSignaturePresetResponse = {
  preset: EmailSignaturePresetConfig | null;
};

export type SaveEmailSignaturePresetRequest = {
  config: EmailSignaturePresetConfig;
};

export type SaveEmailSignaturePresetResponse = {
  preset: EmailSignaturePresetConfig;
};

const baseEmailSignatureApi = {
  getOptions: () =>
    apiClient.get<EmailSignatureOptionsResponse>(
      "/api/admin/email-signature/options"
    ),

  // ✅ load saved preset
  getPreset: () =>
    apiClient.get<GetEmailSignaturePresetResponse>(
      "/api/admin/email-signature/preset"
    ),

  // ✅ upsert saved preset
  savePreset: (body: SaveEmailSignaturePresetRequest) =>
    apiClient.put<SaveEmailSignaturePresetResponse>(
      "/api/admin/email-signature/preset",
      body
    ),
};

const emailSignatureApi = wrapApiWithTokenRefresh(baseEmailSignatureApi, []);

export default emailSignatureApi;
