import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseDocTemplatesApi = {
  // optional kind filter: /doc-templates?kind=faq
  getList: (params?: { kind?: string }) =>
    apiClient.get("/api/admin/doc-templates", { params }),
  getItem: (id: string) => apiClient.get(`/api/admin/doc-templates/${id}`),
  upsertItem: (payload: object) =>
    apiClient.post("/api/admin/doc-templates", payload),
  remove: (id: string) => apiClient.delete(`/api/admin/doc-templates/${id}`),

  removeMany: (ids: string[]) =>
    apiClient.delete("/api/admin/doc-templates", {
      data: { ids },
    }),
  exportDocx: (id: string) =>
    apiClient.get(`/api/admin/doc-templates/${id}/export-docx`, {
      // depends on your apiClient impl, but usually:
      responseType: "blob",
    }),
};

const docTemplatesApi = wrapApiWithTokenRefresh(baseDocTemplatesApi, []);

export default docTemplatesApi;
