import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseDocTemplateKindsApi = {
  getList: (params?: { search?: string; onlyActive?: "all" | "yes" | "no" }) =>
    apiClient.get("/api/admin/doc-template-kinds", { params }),
  getOne: (id: string) => apiClient.get(`/api/admin/doc-template-kinds/${id}`),
  upsertItem: (payload: {
    id?: string;
    code: string;
    label: string;
    description?: string | null;
    is_active?: boolean;
    sort_order?: number;
  }) =>
    payload.id
      ? apiClient.put(`/api/admin/doc-template-kinds/${payload.id}`, payload)
      : apiClient.post("/api/admin/doc-template-kinds", payload),

  remove: (id: string) =>
    apiClient.delete(`/api/admin/doc-template-kinds/${id}`),
  removeMany: (ids: string[]) =>
    apiClient.delete("/api/admin/doc-template-kinds", {
      data: { ids },
    }),
};

const docTemplateKindsApi = wrapApiWithTokenRefresh(
  baseDocTemplateKindsApi,
  []
);

export default docTemplateKindsApi;
