// src/api/routes/device-brands.js
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseDeviceBrandsApi = {
  getList: (query) => apiClient.get(`/api/admin/device-brands/list${query}`),
  postCreate: (data) => apiClient.post("/api/admin/device-brands/save", data),
  getEdit: (id) => apiClient.get(`/api/admin/device-brands/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/device-brands/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/device-brands/delete", { ids }),
};

const deviceBrandsApi = wrapApiWithTokenRefresh(baseDeviceBrandsApi, [
  "getList",
]);
export default deviceBrandsApi;
