import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseCompanySegmentsApi = {
  // Accept either a query string (old style) OR params object (new style)
  getList: (paramsOrQuery) => {
    if (typeof paramsOrQuery === "string") {
      // old use: getList(`?page=1&...`)
      return apiClient.get(`/api/admin/company-segments/list${paramsOrQuery}`);
    }
    // new use: getList({ page, pageSize, sortField, sortDirection, searchTerm })
    return apiClient.get("/api/admin/company-segments/list", {
      params: paramsOrQuery,
    });
  },

  getAllNames: () => apiClient.get("/api/admin/company-segments/all-names"),

  // create from “Create page” or modal
  create: (data) => apiClient.post("/api/admin/company-segments/create", data),

  // used by ExpandedCompanySegment
  getOne: (id) => apiClient.get(`/api/admin/company-segments/edit/${id}`),
  update: (id, data) =>
    apiClient.post(`/api/admin/company-segments/edit/${id}`, data),

  // bulk delete or single delete
  delete: (ids) =>
    apiClient.post("/api/admin/company-segments/delete", { ids }),

  // OPTIONAL: keep old names if something already uses them
  postCreate: (data) =>
    apiClient.post("/api/admin/company-segments/create", data),
  getEdit: (id) => apiClient.get(`/api/admin/company-segments/edit/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/company-segments/edit/${id}`, data),
};

const companySegmentsApi = wrapApiWithTokenRefresh(baseCompanySegmentsApi, [
  // "getCompanyList" does not exist, so it should be something real or empty
  "getList",
  "getAllNames",
  "create",
  "getOne",
  "update",
  "delete",
]);

export default companySegmentsApi;
