import apiClient from "@/lib/apiClient";

export type ChecklistItem = { id: string; text: string; done: boolean };

export type NoteComment = {
  id: string;
  author_id: string | null;
  author_name?: string | null;
  body: string;
  is_public: boolean;
  checklist: ChecklistItem[];
  created_at: string;
  updated_at?: string;
};

export const commentsApi = {
  thread: {
    list: (threadRef: string) =>
      apiClient.get<{ comments: NoteComment[] }>(
        `/api/admin/threads/${threadRef}/comments`
      ),
    create: (
      threadRef: string,
      payload: {
        body: string;
        isPublic?: boolean;
        checklist?: ChecklistItem[];
        commentType?: string;
      }
    ) => apiClient.post(`/api/admin/threads/${threadRef}/comments`, payload),
  },

  actionItem: {
    list: (actionItemRef: string) =>
      apiClient.get<{ comments: NoteComment[] }>(
        `/api/admin/action-items/${actionItemRef}/comments`
      ),
    create: (
      actionItemRef: string,
      payload: {
        body: string;
        isPublic?: boolean;
        checklist?: ChecklistItem[];
      }
    ) =>
      apiClient.post(
        `/api/admin/action-items/${actionItemRef}/comments`,
        payload
      ),
  },

  // decision + meeting ugyanígy, ha felvetted backend route-ot
};
export default commentsApi;
