import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseCollectionSnapshotsApi = {
  getAll: () => apiClient.get(`/api/admin/collection-snapshots/list`),
  postCreate: () => apiClient.post(`/api/admin/collection-snapshots/create`),
  postRestore: (id) =>
    apiClient.post(`/api/admin/collection-snapshots/restore/${id}`),
};
const collectionSnapshotsApi = wrapApiWithTokenRefresh(
  baseCollectionSnapshotsApi,
  [""]
);

export default collectionSnapshotsApi;
