// app/api/routes/audit-log.ts
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseAuditLogApi = {
  // query is like `?page=1&pageSize=25&username=...`
  getList: (query: string) => apiClient.get(`/api/admin/audit-log${query}`),

  getOne: (id: string) => apiClient.get(`/api/admin/audit-log/${id}`),
};

const auditLogApi = wrapApiWithTokenRefresh(baseAuditLogApi, []);

export default auditLogApi;
