import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseAdminOrdersApi = {
  getList: (query) => apiClient.get(`/api/admin/admin-orders/list${query}`),
  putCreate: (data) => apiClient.put("/api/admin/admin-orders/create", data),
  getEdit: (id) => apiClient.get(`/api/admin/admin-orders/edit/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/admin-orders/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/admin-orders/delete", ids),
  getById: (id) => apiClient.get(`/api/admin/admin-orders/order/${id}`),
  updateDeliveryStatus: (id, data) =>
    apiClient.post(`/api/admin/admin-orders/delivery-state/${id}`, data),
};
const adminOrdersApi = wrapApiWithTokenRefresh(baseAdminOrdersApi, []);
export default adminOrdersApi;
