import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseAdminMenuCategoryApi = {
  getAll: (query) =>
    apiClient.get(`/api/admin/admin-menu-category/list${query}`),
  getTree: () => apiClient.get(`/api/admin/admin-menu-category/tree`),
  getCreate: () => apiClient.get("/api/admin/admin-menu-category/create"),
  postCreate: (data) =>
    apiClient.post("/api/admin/admin-menu-category/create", data),
  getById: (id) => apiClient.get(`/api/admin/admin-menu-category/edit/${id}`),
  update: (id, data) =>
    apiClient.post(`/api/admin/admin-menu-category/edit/${id}`, data),
  deleteAdminMenuCategory: (ids) =>
    apiClient.post("/api/admin/admin-menu-category/delete-category", ids),
  getReorder: () => apiClient.get("/api/admin/admin-menu-category/reorder"),
  postReorder: (data) =>
    apiClient.post("/api/admin/admin-menu-category/reorder", data),
  updateSorting: (id, sorting) =>
    apiClient.post(`/api/admin/admin-menu-category/update-sorting`, {
      id,
      sorting,
    }),
  upsertTree: (data) =>
    apiClient.post(`/api/admin/admin-menu-category/upsert-tree`, data),
};
const adminMenuCategoryApi = wrapApiWithTokenRefresh(baseAdminMenuCategoryApi, [
  "getAll",
]);

export default adminMenuCategoryApi;
