import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseAuthApi = {
  getAdmin: () => apiClient.get("/api/admin/auth/get/user"),
  postLogin: (data) => apiClient.post("/api/admin/auth/login", data),
  postLogout: () => apiClient.post("/api/admin/auth/logout"),
  postDeviceLogout: (sessionId) =>
    apiClient.post("/api/admin/auth/logout-device", { sessionId }),
  secureAccount: (email) =>
    apiClient.post("/api/admin/auth/secure-account", { email }),
  refreshToken: () => apiClient.post("/api/admin/auth/refresh-token"),
  getSocketToken: () => apiClient.get("/api/admin/auth/socket-token"),
};

// ✅ Wrap selected methods automatically
const authApi = wrapApiWithTokenRefresh(baseAuthApi, [
  "postDeviceLogout",
  "secureAccount",
]);

export default authApi;
