"use client";

import React, { useEffect } from "react";

function cn(...classes: Array<string | false | null | undefined>) {
  return classes.filter(Boolean).join(" ");
}

export function Drawer({
  open,
  onClose,
  title,
  children,
  widthClass = "max-w-xl",
}: {
  open: boolean;
  onClose: () => void;
  title: string;
  children: React.ReactNode;
  widthClass?: string;
}) {
  useEffect(() => {
    function onKey(e: KeyboardEvent) {
      if (e.key === "Escape") onClose();
    }
    if (open) window.addEventListener("keydown", onKey);
    return () => window.removeEventListener("keydown", onKey);
  }, [open, onClose]);

  if (!open) return null;

  return (
    <div className="fixed inset-0 z-50">
      <div
        className="absolute inset-0 bg-black/40"
        onClick={onClose}
        aria-hidden="true"
      />
      <div
        className={cn(
          "absolute right-0 top-0 h-full w-full bg-white shadow-2xl",
          widthClass
        )}>
        <div className="flex items-center justify-between border-b border-slate-200 px-4 py-3">
          <div className="text-base font-extrabold">{title}</div>
          <button
            className="rounded-lg px-2 py-1 text-sm font-semibold text-slate-600 hover:bg-slate-100"
            onClick={onClose}>
            ✕
          </button>
        </div>
        <div className="h-[calc(100%-52px)] overflow-y-auto p-4">
          {children}
        </div>
      </div>
    </div>
  );
}
